Ext.data.JsonP.sol_common_Template({"tagname":"class","name":"sol.common.Template","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.Template.js","href":"lib_sol.common.Template.html#sol-common-Template"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"eloas":true,"elojc":true,"requires":["sol.common.CounterUtils","sol.common.ObjectFormatter.TemplateSord","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.TranslateTerms","sol.common.as.BarcodeUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"source","tagname":"cfg","owner":"sol.common.Template","id":"cfg-source","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"isRepoPath","tagname":"property","owner":"sol.common.Template","id":"property-isRepoPath","meta":{}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"template","tagname":"property","owner":"sol.common.Template","id":"property-template","meta":{}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"apply","tagname":"method","owner":"sol.common.Template","id":"method-apply","meta":{}},{"name":"applySord","tagname":"method","owner":"sol.common.Template","id":"method-applySord","meta":{}},{"name":"compile","tagname":"method","owner":"sol.common.Template","id":"method-compile","meta":{"private":true}},{"name":"getResult","tagname":"method","owner":"sol.common.Template","id":"method-getResult","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.Template","id":"method-initialize","meta":{"private":true}},{"name":"load","tagname":"method","owner":"sol.common.Template","id":"method-load","meta":{}},{"name":"registerCustomHelper","tagname":"method","owner":"sol.common.Template","id":"method-registerCustomHelper","meta":{}},{"name":"setSource","tagname":"method","owner":"sol.common.Template","id":"method-setSource","meta":{}}],"code_type":"ext_define","id":"class-sol.common.Template","short_doc":"This class encapsulates templating operations by handlebars.js. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.Template</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.CounterUtils' rel='sol.common.CounterUtils' class='docClass'>sol.common.CounterUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter.TemplateSord' rel='sol.common.ObjectFormatter.TemplateSord' class='docClass'>sol.common.ObjectFormatter.TemplateSord</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.TranslateTerms' rel='sol.common.TranslateTerms' class='docClass'>sol.common.TranslateTerms</a></div><div class='dependency'><a href='#!/api/sol.common.as.BarcodeUtils' rel='sol.common.as.BarcodeUtils' class='docClass'>sol.common.as.BarcodeUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.Template.html#sol-common-Template' target='_blank'>lib_sol.common.Template.js</a></div></pre><div class='doc-contents'><p>This class encapsulates templating operations by handlebars.js.</p>\n\n<p>For more information on using templates and the template syntax of handlebars please refer to\n<a href=\"http://www.handlebarsjs.com/\">www.handlebarsjs.com</a>.</p>\n\n<h1>Using templates from a string</h1>\n\n<pre><code>var tpl = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>('<a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>', {\n    source: 'Hello {{name}}.'\n});\n\nvar result = tpl.apply({\n  name: 'Marcus'\n});\n</code></pre>\n\n<h1>Using templates from an elo text file</h1>\n\n<pre><code>var tpl = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>('<a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>', {});\n\n// load data from a text file in ELO\ntpl.load('GUID');\n\n// accessing objKey properties is difficult.\n// use <a href=\"#!/api/sol.common.ObjectFormatter\" rel=\"sol.common.ObjectFormatter\" class=\"docClass\">sol.common.ObjectFormatter</a> to get an easy to use sord object.\nvar data = <a href=\"#!/api/sol.common.ObjectFormatter-method-format\" rel=\"sol.common.ObjectFormatter-method-format\" class=\"docClass\">sol.common.ObjectFormatter.format</a>({\n  sord: {\n    formatter: '<a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">sol.common.ObjectFormatter.TemplateSord</a>',\n    data: sord\n});\n\nvar result = tpl.apply(data);\n</code></pre>\n\n<h1>Helper functions</h1>\n\n<h2>Date formatting: formatDate</h2>\n\n<p>Registers the templating function <code>formatDate</code>. For all formating strings <a href=\"http://momentjs.com/\">moment.js</a> syntax will be used.</p>\n\n<pre><code>{{formatDate outputFormat inputDate inputFormat}}\n</code></pre>\n\n<p>All parameters are optional:</p>\n\n<ul>\n<li>outputFormat {String} default: 'YYYYMMDDHHmmss'</li>\n<li>inputDate {Date|String} default: the current date</li>\n<li>inputFormat {String} default: 'YYYYMMDDHHmmss'</li>\n</ul>\n\n\n<p>But, if an inputDate is defined, the outputFormat has to be set (even if it is to an empty string), and if an inputFormat is defined, both previous parameters have to be defined.</p>\n\n<p>The following example would output a human readable date from a index field:</p>\n\n<pre><code>{{formatDate 'DD.MM.YYYY HH:mm:ss' sord.objKeys.MY_DATE}}\n</code></pre>\n\n<h2>monthName</h2>\n\n<p>Registers the <code>monthName</code> helper which returns the month name of a date.</p>\n\n<pre><code>{{{monthName isoDate=sord.objKeys.INVOICE_DATE textStyle='SHORT' locale='de'}}}\n</code></pre>\n\n<h2>Counter</h2>\n\n<p>Registers the <code>count</code> helper which allows the use of IX conters in Template Strings.</p>\n\n<pre><code>{{count 'MY_COUNTER'}}\n</code></pre>\n\n<p>It also supports the normalization of the counter results to a spezific length by padding characters on the left side.\nThis can be configured, by a second parameter with a string of the desired length an containing the desired characters.\nIf the counter value has a greater length then the parameter, it will not be altered.</p>\n\n<pre><code>{{count 'MY_COUNTER' '0000'}}  // all returned values will be of the length 4 and the missing positions will be fitted with zeros\n</code></pre>\n\n<p>Another spezial feature of this helper is the use of template statements inside the counter name parameter</p>\n\n<pre><code>{{count 'MY_COUNTER_{{sord.objKeys.FILE_REFERENCE}}'}} // this will create a counter for every file reference\n</code></pre>\n\n<h2>ObjKey Iterator: eachObjKey</h2>\n\n<p>Registers the templating iterator <code>eachObjKey</code> to iterate over an array of object keys.\nThis Iterator handles the String[] array of the ObjKey-value property.</p>\n\n<p>The enclosed context can use the properties name and value. Please note that <code>eachObjKey</code> is only required\nif <a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">sol.common.ObjectFormatter.TemplateSord</a> is not used.</p>\n\n<pre><code>{{#eachObjKey sord}}{{name}}: {{value}}{{/eachObjKey}}\n</code></pre>\n\n<h2>Map values helper: mapTable</h2>\n\n<p>Registers the templating iterator <code>mapTable</code> to iterate over an object with object keys\nwhich ends with an index number</p>\n\n<pre><code>{{#mapTable mapKeys indicatorKey=\"INVI_POS_NO\"}}\n  {{INVI_POS_NO}} {{INVI_POS_DATA}}\n{{/mapTable}}\n\n// example map table\nINVI_POS_NO1 = \"1\"\nINVI_POS_NO2 = \"2\"\nINVI_POS_DATA1 = \"Data 123\"\nINVI_POS_DATA2 = \"Data 345\"\n</code></pre>\n\n<p><code>#mapTable</code> is an iterator with an isolated scope. Values of the sord can still be accessed using <code>../</code>.</p>\n\n<pre><code>{{#mapTable mapKeys indicatorKey=\"INVI_POS_NO\"}}\n  {{../sord.objKeys.INVOICE_NO}} {{INVI_POS_NO}} {{INVI_POS_DATA}}\n{{/mapTable}}\n</code></pre>\n\n<h2>Substring helper: substring</h2>\n\n<p>Registers the templating function <code>substring</code>, which allows to only use parts from an input value.</p>\n\n<pre><code>{{substring stringProperty 0 4}}\n{{substring stringProperty 0 1 uppercase='true'}}\n</code></pre>\n\n<h2>Replace helper: replace</h2>\n\n<pre><code>{{replace INVI_GROSS_AMOUNT '-' ''}}\n</code></pre>\n\n<h2>Translation helper: translate</h2>\n\n<p>Registers the templating function <code>translate</code>, which allows to use translation keys in the templates.</p>\n\n<p>The language string is optional. If it is omitted, the function tries to get the language from the connection.</p>\n\n<pre><code>{{translate stringProperty languageProperty}}\n</code></pre>\n\n<p>or</p>\n\n<pre><code>{{translate \"this.is.a.TranslationKey\", \"de\"}}\n</code></pre>\n\n<h2>Barcode creation helper: base64Barcode</h2>\n\n<p>Registers the templating function <code>base64Barcode</code> which creates barcode images for Apache FOP reports.</p>\n\n<p>QR code example:</p>\n\n<pre><code>{{base64Barcode type=\"QR_CODE\" content=\"elodms://12345\"}}\n</code></pre>\n\n<p>Code 39 example:</p>\n\n<pre><code>{{base64Barcode type=\"CODE_39\" content=\"HELLO\"}}\n</code></pre>\n\n<p>Interleaved 2 of 5 example:</p>\n\n<pre><code>{{base64Barcode type=\"ITF\" content=\"123456\"}}\n</code></pre>\n\n<p>Apache FOP integration example:</p>\n\n<pre><code>&lt;fo:block&gt;&lt;fo:external-graphic src=\"url('data:image/png;base64,{{base64Barcode content=\"dms://{{sord.guid}}\" type=\"QR_CODE\"}}')\"/&gt;&lt;/fo:block&gt;\n</code></pre>\n\n<h2>Image as Base 64 helper: base64Image</h2>\n\n<p>Loads an image from the repository by the object ID and returns it as base64 encoded String</p>\n\n<p>Example:</p>\n\n<pre><code>var base64Content = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>\", { source: \"{{base64Image objId='{{sord.objKeys.VISITOR_PHOTO_GUID}}'}}\" }).applySord(sord);\n</code></pre>\n\n<p>Apache FOP integration example</p>\n\n<pre><code>&lt;fo:block&gt;&lt;fo:external-graphic src=\"url('data:image/jpg;base64,{{base64Image objId='{{hierarchy.visitor.objKeys.VISITOR_PHOTO_GUID}}'}}')\"/&gt;&lt;/fo:block&gt;\n</code></pre>\n\n<h2>Using if conditions if, ifCond</h2>\n\n<p>Handlebars provides an easy way to check if a value is given using the build in helper</p>\n\n<pre><code>{{#if sord.name}} ... {{/if}}\n</code></pre>\n\n<p>Camparison of Strings can be realised thanks to ifCond. Please note that the compare iterator must be passed as a string value.</p>\n\n<pre><code>{{#ifCond sordA.name '==' sordB.name}} ... {{/ifCond}}\n{{#ifCond sordA.objKeys.NET_AMOUNT '&lt;' sordB.objKeys.NET_AMOUNT}} ... {{/ifCond}}\n</code></pre>\n\n<p>Following operators are supported by ifCond:</p>\n\n<pre><code>==  ===  !==  !=  &lt;  &lt;=  &gt;  &gt;=  &amp;&amp;  ||\n</code></pre>\n\n<h2>Bock helper 'ifNegative'</h2>\n\n<pre><code>{{#ifNegative INVI_GROSS_AMOUNT}} ... {{ifNegative}}\n</code></pre>\n\n<h2>Using if conditions if, ifContains</h2>\n\n<p>Handlebars provides an easy way to check if a value is given using the build in helper</p>\n\n<pre><code>{{#if sord.name}} ... {{/if}}\n</code></pre>\n\n<p>A string can be searched for another string thanks to ifContains.</p>\n\n<pre><code>{{#ifContains sordA.name sordB.name}} ... {{/ifContains}}\n{{#ifContains sordA.objKeys.DESCRIPTION 'INV'}} ... {{/ifContains}}\n</code></pre>\n\n<h2>Block helper 'ifKey'</h2>\n\n<p>   {{#ifKey ../objKeys.INVOICE_TYPE 'CN'}} ... {{/ifKey}}</p>\n\n<h2>Current user</h2>\n\n<p>The current user name can be given by</p>\n\n<pre><code>{{currentUser}}\n</code></pre>\n\n<p>Additional properties like the user id can be accessed thanks to an optional property.\nFollowing properties are supported:</p>\n\n<pre><code>{{currentUser 'id'}}\n{{currentUser 'guid'}}\n{{currentUser 'desc'}}\n</code></pre>\n\n<p>By default or if properties are passed that are not mentioned above the users name ist returned.</p>\n\n<h2>Get user folder GUIDs</h2>\n\n<p>Every ELO user has a folder that allows storing personal data. The following helper will return the guid of this folder based on the current user session.</p>\n\n<pre><code>{{userFolder}}\n</code></pre>\n\n<p>In addition the default subfolders can be adressed as well</p>\n\n<pre><code>{{userFolder 'private'}}\n{{userFolder 'data'}}\n{{userFolder 'inbox'}}\n</code></pre>\n\n<h2>Pad left</h2>\n\n<pre><code>{{padLeft sord.objKeys.VENDOR_NO '0000000000'}}\n</code></pre>\n\n<h2>Number</h2>\n\n<p>Returns a number with a dot as decimal separator</p>\n\n<p>   {{number sord.mapKeys.INVI_TOTAL_NET_PRICE1}}</p>\n\n<h2>Abs</h2>\n\n<p>Returns a number without sign</p>\n\n<p>   {{{abs INVI_GROSS_AMOUNT}}}</p>\n\n<h2>Helper 'debitCreditIndicator':</h2>\n\n<p>Returns an indicator that shows if an amount is negative</p>\n\n<p>   {{debitCreditIndicator INVI_GROSS_AMOUNT 'S' 'H'}}</p>\n\n<h2>External link</h2>\n\n<p>Creates an external link and returns the appropriate URL</p>\n\n<pre><code>{{{externalLink objId='{{{sord.id}}}' limitTo=1 limitToUnit='y' times=5}}}\n</code></pre>\n\n<h2>Sum map field values</h2>\n\n<p>   Iterates over an object with map keys which ends with an index number.\n   The values of the specified field are summed.</p>\n\n<p>   {{mapFieldSum sord.mapKeys field='INVI_POS_DATA' decimals=2 onlyIfEmpty='INVI_POS_OPT' onlyIfNotEmpty='INVI_POS_NR'}}</p>\n\n<pre><code>// example map data\nINVI_POS_NR1 = \"01\"\nINVI_POS_DATA1 = \"1\"\nINVI_POS_NR2 = \"02\"\nINVI_POS_DATA2 = \"2\"\nINVI_POS_NR3 = \"03\"\nINVI_POS_DATA3 = \"3\"\nINVI_POS_NR4 = \"04\"\nINVI_POS_DATA4 = \"4,333\"\nINVI_POS_NR5 = \"05\"\nINVI_POS_DATA5 = \"5,333\"\nINVI_POS_OPT5 = \"Test\"\n\nReturns: 10,33\n</code></pre>\n\n<h2>Current user</h2>\n\n<p>The current user name can be given by</p>\n\n<pre><code>{{currentUser}}\n</code></pre>\n\n<p>Additional properties like the user id can be accessed thanks to an optional property.\nFollowing properties are supported:</p>\n\n<pre><code>{{currentUser 'id'}}\n{{currentUser 'guid'}}\n{{currentUser 'desc'}}\n</code></pre>\n\n<p>By default or if properties are passed that are not mentioned above the users name ist returned.</p>\n\n<h2>Block helper 'minDate'</h2>\n\n<p>   Iterates over an array and determinates the minimum date.</p>\n\n<p>   {{#minDate sords format='DD.MM.YYYY'}}{{objKeys.INVOICE_DATE}}{{/minDate}}</p>\n\n<h2>Block helper 'maxDate'</h2>\n\n<p>   Iterates over an array and determinates the minimum date.</p>\n\n<p>   {{#maxDate sords format='DD.MM.YYYY'}}{{objKeys.INVOICE_DATE}}{{/maxDate}}</p>\n\n<h2>Custom</h2>\n\n<p>This helper lets you use your previously by <a href=\"#!/api/sol.common.Template-method-registerCustomHelper\" rel=\"sol.common.Template-method-registerCustomHelper\" class=\"docClass\">registerCustomHelper</a> registered functions.\nThis only works in ELO modules which support the 'globalScope' (currently only JavaClient and IndexServer).</p>\n\n<p>To register a custom helper, create an instance of '<a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>' and register your helper function.</p>\n\n<p>The script can NOT start with the <code>lib_</code> prefix.</p>\n\n<p>A <code>your.namespace.CustomHelper.js</code> could be implemented like this:</p>\n\n<pre><code>//&amp;#64;include lib_sol.common.Template.js\n\n(function () {\n  var tpl = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>\");\n\n  tpl.registerCustomHelper(\"hello\", function (config) {\n    return \"hello \" + arguments[0];\n  });\n\n  // register further helpers\n\n}());\n</code></pre>\n\n<p>It is important this registration is executed bevor a custom helper will be used for the first time.\nE.g. when the scripts are loaded like in the example above.</p>\n\n<p>The helper will used with <code>{{custom '%HELPER_NAME%' %ADDITIONAL_ARGS% }}</code>:</p>\n\n<pre><code>var tpl = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>\", { source: \"{{custom 'hello' name}}\" });\nvar str = tpl.apply({ name: \"hans\" });\n</code></pre>\n\n<p>This will result in <code>str =&gt; hello hans</code></p>\n\n<p>Another implementation of the same helper function might look like this:</p>\n\n<pre><code>...\n  var tpl = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>\");\n  var fct = function (cfg) {\n    return \"hello \" + cfg.hash.name;\n  };\n  tpl.registerCustomHelper(\"hello\", fct);\n...\n</code></pre>\n\n<p>Which would then be used like this (to the same result):</p>\n\n<pre><code>var tpl = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a>\", { source: \"{{custom 'hello' name=name}}\" });\nvar str = tpl.apply({ name: \"hans\" });\n</code></pre>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-source' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-cfg-source' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-cfg-source' class='name expandable'>source</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Template source as a string. ...</div><div class='long'><p>Template source as a string.</p>\n\n<pre><code>    source = \"Hello {{name}}.\"\n</code></pre>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-isRepoPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-property-isRepoPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-property-isRepoPath' class='name expandable'>isRepoPath</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>If true the given string is a repository path and the separator is replaced by pilcrow.</p>\n</div><div class='long'><p>If true the given string is a repository path and the separator is replaced by pilcrow.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-template' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-property-template' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-property-template' class='name expandable'>template</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Compiled handlebars.js template.</p>\n</div><div class='long'><p>Compiled handlebars.js template.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-apply' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-method-apply' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-method-apply' class='name expandable'>apply</a>( <span class='pre'>paramObj</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Apply the template with the object data. ...</div><div class='long'><p>Apply the template with the object data.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>paramObj</span> : Object<div class='sub-desc'><p>Data object which contains the data to fill in.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applySord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-method-applySord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-method-applySord' class='name expandable'>applySord</a>( <span class='pre'>sord</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Renders the template with the sord data. ...</div><div class='long'><p>Renders the template with the sord data.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : String|de.elo.ix.client.Sord<div class='sub-desc'><p>Object ID of the element or a Sord.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-compile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-method-compile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-method-compile' class='name expandable'>compile</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Compiles the template string. ...</div><div class='long'><p>Compiles the template string.</p>\n</div></div></div><div id='method-getResult' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-method-getResult' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-method-getResult' class='name expandable'>getResult</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-method-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-method-load' class='name expandable'>load</a>( <span class='pre'>objId</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads the template string from an ELO document ...</div><div class='long'><p>Loads the template string from an ELO document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>ELO object ID</p>\n</div></li></ul></div></div></div><div id='method-registerCustomHelper' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-method-registerCustomHelper' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-method-registerCustomHelper' class='name expandable'>registerCustomHelper</a>( <span class='pre'>name, fct</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Registers an helper function globally. ...</div><div class='long'><p>Registers an helper function globally. This function can be used later by using the custom helper.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>Name of the helper</p>\n</div></li><li><span class='pre'>fct</span> : Function<div class='sub-desc'><p>The function which will be used by the custom helper. This function recieves all parameters that are handed over to the custom helper after the name of the called cutom helper.</p>\n</div></li></ul></div></div></div><div id='method-setSource' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.Template'>sol.common.Template</span><br/><a href='source/lib_sol.common.Template.html#sol-common-Template-method-setSource' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.Template-method-setSource' class='name expandable'>setSource</a>( <span class='pre'>source, isRepoPath</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the source from a template string ...</div><div class='long'><p>Sets the source from a template string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>isRepoPath</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true}});